<?

// --------------------------------
// Training set date
// --------------------------------
$page_split = 6; // pageing line count

// --------------------------------
// Get Instructor list
// --------------------------------
$instructor_list = array();
$SQL = " SELECT ir.*, (SELECT COUNT(tr_idx) FROM training WHERE tr_ir_idx = ir.ir_idx) AS tr_cnt ";
$SQL.= " FROM instructor ir ";
$SQL.= " WHERE ir.ir_active = 'Y' ";
$SQL.= " ORDER BY ir.ir_order ASC ";
$Result = mysqli_query($conn, $SQL);
while ($ResultsRow = mysqli_fetch_array($Result, MYSQLI_ASSOC)) {
	array_push($instructor_list, $ResultsRow);
}

// --------------------------------
// Get Training information
// --------------------------------
$training_list   = array();

// $SQL = " SELECT tr.*, ir.* ";
// $SQL.= " FROM training tr ";
// $SQL.= " LEFT OUTER JOIN instructor ir ON ir.ir_idx = tr.tr_ir_idx ";
// //$SQL.= " WHERE tr.tr_open   = 'Open' ";
// $SQL.= " WHERE tr.tr_open   <> '' ";
// $SQL.= " AND   ir.ir_active = 'Y' ";
// $SQL.= " ORDER BY ir.ir_order ASC, tr.tr_order ASC ";

$SQL =" SELECT ";
$SQL.="       tr.*, ir.* ";
$SQL.="     , CASE WHEN tr.tr_open = 'Open'     THEN 1 ";
$SQL.="            WHEN tr.tr_open = 'Schedule' THEN 2 ";
$SQL.="            WHEN tr.tr_open = 'Close'    THEN 3 ";
$SQL.="            ELSE 9 ";
$SQL.="       END AS open_order ";
$SQL.=" FROM training tr ";
$SQL.=" LEFT OUTER JOIN instructor ir ON ir.ir_idx = tr.tr_ir_idx ";
$SQL.=" WHERE tr.tr_open IN ('Open', 'Schedule', 'Close') ";
$SQL.=" AND   ir.ir_active = 'Y' ";
$SQL.=" ORDER BY ir.ir_order ASC, open_order ASC, tr.tr_order ASC ";
$Result = mysqli_query($conn, $SQL);

while ($ResultsRow = mysqli_fetch_array($Result, MYSQLI_ASSOC)) {
	array_push($training_list, $ResultsRow);
}

?>

<!-- =========================
	TRAINING SECTION
============================== -->
<section id="program" class="parallax-section">
	<div class="container">
		<div class="row">

			<div class="wow fadeInUp col-md-12 col-sm-12" data-wow-delay="0.5s">
				<div class="section-title">
					<h2>Drug Development</h2>
					<p></p>
				</div>
			</div>

			<div class="wow fadeInUp col-md-10 col-sm-10" data-wow-delay="0.6s">
				<!-- Nav tabs -->
				<ul class="nav nav-tabs" role="tablist">
				<?
				for ($iri=0; $iri < count($instructor_list); $iri++) {
					if($instructor_list[$iri][tr_cnt] > 0){
				?>
					<li class="<?=$iri == 0 ? "active" : "" ?>">
						<a href="#ir_content_<?=$instructor_list[$iri][ir_order]?>" aria-controls="ir_content_<?=$instructor_list[$iri][ir_order]?>" role="tab" data-toggle="tab">
							<?=$instructor_list[$iri][ir_category]?>
						</a>
					</li>
				<?
					}
				}
				?>
					<!-- <li class="active"><a href="#tday" aria-controls="tday" role="tab" data-toggle="tab">ENTERTAINMENTS!</a></li> -->
				</ul>
				<!-- tab panes -->
				<div class="tab-content">
				<?
				for ($iri=0; $iri < count($instructor_list); $iri++) {
					if($instructor_list[$iri][tr_cnt] > 0){
				?>
					<div role="tabpanel" class="tab-pane <?=$iri == 0 ? "active" : "" ?>" id="ir_content_<?=$instructor_list[$iri][ir_order]?>">
						<div id="ir_carousel_<?=$instructor_list[$iri][ir_order]?>" class="carousel slide" data-interval="false" data-wrap="false" data-keyboard="false">

							<div class="row">
								<div class="col-md-12 col-sm-12">
									<h3><?=$instructor_list[$iri][ir_name]?></h3>
								</div>
								<div class="col-md-2 col-sm-2">
									<img src="<?=$instructor_list[$iri][ir_picture]?>" class="img-responsive" alt="program">
								</div>
								<div class="col-md-6 col-sm-6">
									<?=$instructor_list[$iri][ir_desc]?>
								</div>
								<div class="col-md-4 col-sm-4">
									<video width="300" controls>
  									<source src="<?=$instructor_list[$iri][ir_video]?>" type="video/mp4">
  									Your browser does not support HTML video.
									</video>
								</div>
							</div>

						<?
						$page_content_cnt = 0;
						$carousel_inner_open = false;
						$carousel_item_open  = false;

						for ($tr=0; $tr < count($training_list); $tr++) {

							if($training_list[$tr][tr_ir_idx] == $instructor_list[$iri][ir_idx]){

								if($page_content_cnt == 0 && !$carousel_inner_open){
									$carousel_inner_open = true;
									echo '<div class="carousel-inner" role="listbox">';
								}
								if($page_content_cnt % $page_split == 0 && !$carousel_item_open){
									$carousel_item_open = true;
									echo '<div class="item '.($page_content_cnt == 0 ? 'active' : '').'">';
								}
						?>
							<!-- program speaker here -->
							<!--
							<div class="col-md-2 col-sm-2">
								<img src="<?=$training_list[$tr][ir_picture]?>" class="img-responsive" alt="program">
							</div>
						-->
							<div class="col-md-12 col-sm-12">
								<h3><?=$training_list[$tr][tr_title]?></h3>
								<h6>
								<? if($training_list[$tr][tr_open]=="Open") { ?>
									<span><i class="fa fa-clock-o"></i> <?=$training_list[$tr][tr_date]?> </span>
									<span>* Cost: $<?=$training_list[$tr][tr_cost]?>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;* Duration: <?=$training_list[$tr][tr_duration]?></span>
								<? } else { ?>
									<!-- <span><i class="fa fa-clock-o"></i> <sapn style="color: red;">To be scheduled</span> </span> -->
									<span><i class="fa fa-clock-o"></i> To be scheduled </span>
									<span></span>
								<? } ?>
								</h6>
								<p><?=$training_list[$tr][tr_desc]?></p>

						<?
						$isCartItem = false;
						foreach ($_SESSION[SESSION_ID."shopping_cart"] as $product) {
							if($product[tridx] == $training_list[$tr][tr_idx]){
								$isCartItem = true;
								break;
							}
						}
						?>

								<?if($training_list[$tr][tr_open]=="Open") {?>
								<!-- Add to Cart Button -->
								<button type="button" class="btn btn-primary addtocart" data-tridx="<?=$training_list[$tr][tr_idx]?>" data-trcost="<?=$training_list[$tr][tr_cost]?>" <?=($isCartItem ? 'disabled' : '')?>>
									<?if($isCartItem) { echo "Already added"; } else { echo "Add to Cart"; }?>
								</button>
								<?}?>

							</div>
						<?
							$page_content_cnt++;
							if( $page_content_cnt % $page_split != 0 && $page_content_cnt != $instructor_list[$iri][tr_cnt] ){
								echo '<div class="program-divider col-md-12 col-sm-12"></div>';
							}

							if($page_content_cnt % $page_split == 0 && $carousel_item_open){
								$carousel_item_open = false;
								echo '</div><!-- end item -->'; // close div
							}

						} // check instructor training

					} // end for $training_list

					if($carousel_item_open){
						$carousel_item_open = false;
						echo '</div><!-- end item last -->'; // close div
					}

					if($carousel_inner_open){
						$carousel_inner_open = false;
						echo '</div><!-- end carousel-inner last -->'; // carousel-inner
					}

					if($page_content_cnt > $page_split){
					?>
						<div class="program-divider col-md-12 col-sm-12" style="margin-bottom: 10px;"></div>

						<!-- Indicators -->
						<div class="col-md-10 col-sm-10" style="text-align:center;">
							<nav aria-label="Page navigation carousel-indicators">
								<ul class="pagination">
									<li data-target="#ir_carousel_<?=$instructor_list[$iri][ir_order]?>" data-slide="prev" class="page-item">
										<a class="page-link" aria-label="Previous">
											<span aria-hidden="true" style="padding-right:0px;">Prev</span>
										</a>
									</li>
									<?
									$total_page  = $instructor_list[$iri][tr_cnt] / $page_split;
									for ($pi=0; $pi < $total_page; $pi++) {
									?>
									<li data-target="#ir_carousel_<?=$instructor_list[$iri][ir_order]?>" data-slide-to="<?=$pi?>" class="page-item"><a class="page-link"><?=($pi+1)?></a></li>
									<?
									}
									?>
									<li data-target="#ir_carousel_<?=$instructor_list[$iri][ir_order]?>" data-slide="next" class="page-item">
										<a class="page-link" aria-label="Next">
											<span aria-hidden="true" style="padding-right:0px;">Next</span>
										</a>
									</li>
								</ul>
							</nav>
						</div>
					<? } ?>

					</div> <!-- end carousel -->

				</div> <!-- tabpanel  -->
				<?
					}
				}
				?>

		</div> <!-- end row -->
	</div> <!-- container -->
</section>



<!------------------------->
<!-- Shopping Cart Modal -->
<!------------------------->
<div class="modal fade" id="modal-cart-info" style="margin-top:150px;">
	<div class="modal-dialog" id="modal-cart-info-dialog">
		<div class="modal-content">
			<div class="modal-header" style="background-color: #0480be; color: white;">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				</button>
				<h4 class="modal-title" id="modal-cart-info-title">
					Add to Cart Information
				</h4>
			</div>
			<div class="modal-body" id="modal-cart-info-body" style="text-align: center;">
				<h3>Registration for all sessions <br/>will be available on August 17th.</h3>
			</div>
		</div>
		<!-- /.modal-content -->
	</div>
	<!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<script type="text/javascript">

$(document).ready(function(){

	//-------------------------------------------
	// Add to Cart
	//-------------------------------------------
	$(document).on('click', 'button.showCart', function(e){
		editcall("","","SHOPPING CART!");
	});

	$(document).on('click', 'button.addtocart', function(e){

		var tridx = $(this).data('tridx');
		var trcost = $(this).data('trcost');
		if(tridx == "16"){
			editcall(tridx,trcost,"SHOPPING CART!");
		}else{
			$('#modal-cart-info').modal();
		}
	});



	//-------------------------------------------
	// Add to Cart Call
	//-------------------------------------------
	function editcall(tridx,trcost,modaltitle) {

		$('#custom-modal').addClass("modal-lg");

		var showEditModal = true;

		if(showEditModal){
			$.ajax({
				method : 'POST',
				url : './cart.php',
				//dataType : 'html',
				data: { 'tr_idx' : tridx, 'tr_cost' : trcost },
				success: function(data){
					$('#modaltitle').text(modaltitle);
					$('#modal-data-edit-body').html(data);
					$('#modal-data-edit').modal();
					$.each($('#modal-data-edit select'), function(i,v){
						$(v).select2();
					});
					// var add_cart_tr_idx = $('#modal-data-edit-body').find('input[name=add_cart_tr_idx]').val();
					// if(add_cart_tr_idx != ''){
					// 	$('button.addtocart[data-tridx=2]').prop('disabled', true);
					// }
				},
				beforeSend: function(jqXHR, settings ){
					showLoading();
				},
				complete: function(jqXHR, status){
					hideLoading();
				},
				error: function(data){
				}
			});
		}
	}//editcall


});

</script>
