<?php
include_once "inc/common.php";
if ($s_m_name == "") {
	echo("<script>window.alert('Checkout can be done after login.');</script>");
	echo("<meta http-equiv='Refresh' content='0; URL=index_new.php'>");
	exit;
}
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<title>KIOSC - Course Payment</title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">

	<!-- MATERIAL DESIGN ICONIC FONT -->
	<link rel="stylesheet" href="fonts/material-design-iconic-font/css/material-design-iconic-font.min.css">
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- STYLE CSS -->
	<link rel="stylesheet" href="css/style_checkout.css?v=2020051401">

	<script src="js/jquery.js"></script>
	<script src="js/checkout.js"></script>

</head>
<body>

	<div class="wrapper" style="background-image: url('images/bg-registration-form-2.jpg');">
		<div class="inner">

			<form class="member-form" id="member-form" action="#" method="post">

				<h3>Course Payment</h3>
				<div class="form-group">
					<div class="form-wrapper">
						<label for="">Full Name<sup></sup></label>
						<input type="text" class="form-control" id="mname" name="mname" value="<?=$s_m_name?>" readonly>
						<div id="nameerror" style="color: #9e251c;"></div>
					</div>
					<div class="form-wrapper">
  						<label for="">Email<sup>*</sup></label>
  						<input type="text" class="form-control" id="memail" name="memail" value="<?=$s_m_email?>" readonly>
  						<div id="emailerror" style="color: #9e251c;"></div>
  					</div>
				</div>
				<!--
				<div class="form-wrapper">
					<label for="">Company Name</label>
					<input type="text" class="form-control" id="mcompany" name="mcompany" value="<?=$s_m_company?>" readonly>
					<div id="typeerror" style="color: #9e251c;"></div>
				</div>
			-->
				<br>
				<br><br>

			</form>

			<div class="cartinfo">
				<br><br>
				<b>Checkout Course Information</b>
				<table class="table table-striped payment-cart" style="font-size:14px;width:100%;border-collapse: collapse;">
					<tr style="border-bottom: 1px solid #dddddd;">
						<td>Description</td>
						<td>Cost</td>
					</tr>
					<?
					$cart_item_idx = 0;
					$total_price = 0;
					$total_krw_price = 0;
					foreach ($_SESSION[SESSION_ID."shopping_cart"] as $product) {
						$total_price = $total_price + $product["trcost"];
						$total_krw_price = $total_krw_price + $product["trcostkrw"];
					?>
					<tr class="payment-cart-item" data-idx="<?=$product[tridx]?>" data-title="<?=$product["trtitle"]?>" data-cost="<?=$product["trcost"]?>" data-cost-krw="<?=$product["trcostkrw"]?>" style="border-bottom: 1px solid #dddddd;">
						<td><?=$product["trtitle"]?></td>
						<td class="cost_text">$<?=$product["trcost"]?> (&#8361;<?=number_format($product["trcostkrw"])?>)</td>
					</tr>
					<?
					}
					?>
					<tr style="font-size:16px;">
						<td>Total Cost</td>
						<td class="total_cost_text">$<?=$total_price?> (&#8361;<?=number_format($total_krw_price)?>)</td>
					</tr>
				</table>
				<input type="hidden" id="total_price" value="<?=$total_price?>"/>
				<input type="hidden" id="total_price_krw" value="<?=$total_krw_price?>"/>
			</div>

			<div class="form-group" style="width: 100%;padding-left: 45px;padding-right: 45px;margin-bottom:25px;">
				<div class="input-group">
					<span class="input-group-addon">Coupon</span>
					<input type="text" class="form-control" id="couponCode" placeholder="Coupon Code" aria-describedby="couponCode" value="">
					<span class="input-group-btn">
						<button class="btn btn-primary btn-coupon" type="button" onclick="checkCouponCode(this)">Apply</button>
					</span>
				</div>
			</div>
			<br><br>

			<!-- Checkout Options -->
			<div class="form-group">
				<div class="col-md-4 col=sm-12" style="padding-left:50px;">
					<button class="btn btn-danger" type="button" onclick="history.back()" style="height:40px;border-radius: 20px;width: 130px;">Cancel</button>
				</div>
				<div class="col-md-8 col=sm-12">
					<!-- Container for PayPal Shortcut Checkout -->
					<button id="danal_payment_card_btn"  class="btn btn-info" type="button" onclick="danalCard()"  style="margin:0px auto;height:40px;border-radius: 20px;width: 150px;display: inline-block; float:right;">신용/체크카드</button>
					<div id="paypal-button-container" style="display: inline-block; margin: 0 10px; width: 250px;float:right;"></div>
				</div>
			</div>

			<br><br>

		</div>
		<!-- /inner -->
	</div>


	<!-- =========================
		 SCRIPTS
	============================== -->
	<script src="js/jquery.js"></script>
	<script type="text/javascript">

	$(document).ready(function(){
		$('#minterest').on('change', function(e){
			if($(this).is(':checked')){
				$('#minterest_info').not(':animated').slideDown();
			}else{
				$('#minterest_info').not(':animated').slideUp();
			}
		});
	});//$(document).ready(function(){
	function checkCouponCode(t){
		var ccode = $.trim($('#couponCode').val());
		if(ccode.length == 0){
			alert('Please input coupon code.');
			return false;
		}
		$.ajax({
			url : 'data_process.php',
			method : 'POST',
			dataType: "JSON",
			async: false,
			data: { 'paymentmode' : 'couponCheck', 'ccode' : ccode},
			success: function(data){
				if(data.completed == "Y"){
					var _total_price = 0;
					var _dis_total_price = 0;
					var _dis_text = "";

					var _total_price_krw = 0;
					var _dis_total_price_krw = 0;
					var _dis_text_krw = "";
					if(data.cp_type == "A"){
						$.each($('.payment-cart .payment-cart-item'), function(i,v){
							var _cost = $(v).data('cost');
							var _dis_cost = _cost;
							if(data.cp_dc_type == "PE"){
								_dis_cost -= Math.floor(_cost * (data.cp_discount / 100) * 100) / 100;
								_dis_text = " ("+data.cp_discount+"% Coupon Applied)";
							}else if(data.cp_dc_type == "PR"){
								_dis_cost = data.cp_discount;
							}
							// $(v).find('.cost_text').html('<span class="price-discount">$'+_cost+'</span> => $'+_dis_cost);
							_total_price += _cost;
							_dis_total_price += _dis_cost;

							var _cost_krw = $(v).data('costKrw');
							var _dis_cost_krw = _cost_krw;
							if(data.cp_dc_type == "PE"){
								_dis_cost_krw -= Math.floor(_cost_krw * (data.cp_discount / 100) * 100) / 100;
								_dis_text_krw = " ("+data.cp_discount+"% Coupon Applied)";
							}else if(data.cp_dc_type == "PR"){
								_dis_cost_krw = data.cp_discount;
							}
							// $(v).find('.cost_text').html('<span class="price-discount">$'+_cost+'</span> => $'+_dis_cost);
							_total_price_krw += _cost_krw;
							_dis_total_price_krw += _dis_cost_krw;
						});
					// }else if(data.cp_type == "I"){
					// }else if(data.cp_type == "T"){
					}
					var total_cost_text_html = '<span class="price-org">$'+_total_price+'</span> <span class="price-discount">$'+_dis_total_price + _dis_text +'</span>';
					total_cost_text_html += '<br/><span class="price-org">$'+_total_price_krw+'</span> <span class="price-discount">$'+_dis_total_price_krw + _dis_text_krw +'</span>';

					$('.payment-cart .total_cost_text').html(total_cost_text_html);
					$("#total_price").val(_dis_total_price);
					$("#total_price_krw").val(_dis_total_price_krw);

				}else{
					var _total_price = 0;
					var _total_price_krw = 0;
					$.each($('.payment-cart .payment-cart-item'), function(i,v){
						var _cost = $(v).data('cost');
						// $(v).find('.cost_text').text('$'+ _cost);
						_total_price += _cost;

						var _cost_krw = $(v).data('costKrw');
						// $(v).find('.cost_text').text('$'+ _cost);
						_total_price_krw += _cost_krw;
					});

					$('.payment-cart .total_cost_text').html('$'+_total_price + "(&#8361;"+ _total_price_krw + ")");
					$("#total_price").val(_total_price);
					$("#total_price_krw").val(_total_price_krw);

					alert("Invalid coupon code. Please try agian.");
				}
			}
			,beforeSend: function(jqXHR, settings ){
				showLoading();
			}
			,error: function(jqXHR, status, error){
				alert("Coupon apply failure. Please try agian.");
			}
			,complete: function(jqXHR, status){
				hideLoading();
			}
		});

	}
	</script>

	<? include "checkout_paypal_new.php"; ?>


	<style>
		#danal_payment_background {
			display: display:none;
			position: absolute;
			top: 0;
			left: 0;
			width: 100%;
			height: 100%;
			width: 100vw;
			height: 100vh;
			max-width: 100%;
			max-height: 100%;
			min-width: 100%;
			min-height: 100%;
			background-color:black;
			cursor: pointer;
			z-index: 9999999900;
		}
		#danal_payment_Info{
			display: none;
			position: absolute;

			font-family: "HelveticaNeue", "HelveticaNeue-Light", "Helvetica Neue Light", helvetica, arial, sans-serif;
			font-size: 16px;
			text-align: center;
			box-sizing: border-box;
			max-width: 420px;
			top: 50%;
			left: 50%;
			position: absolute;
			transform: translateX(-50%) translateY(-50%);
			text-align: center;
			color: #fff;
			z-index: 9999999999;
		}

		#danal_payment_Info a{
			color: #fff;
			cursor: pointer;
		}

		#danal_payment_Info .danal-payment-close{
			position: absolute; right: 0; top: 0; width: 16px; height: 16px; opacity: 0.7; float: right;
		}
	</style>

	<div class="modal fade checkout-modal fullscreen-modal" tabindex="-1" role="dialog" aria-hidden="true" style="z-index:9999999;">
		<div id="danal_payment_background" style="display: none;"></div>
		<div id="danal_payment_Info">
			<a class="danal-payment-close" href="javascript:closeDanal();">X</a>
			<br/><br/>
			<p>다날 결제중입니다.</p>
			<br/>
			<p>결제 브라우저가 보이지 않으신가요?</p>
			<p>창을 다시 실행하여 결제를 완료 할 수 있도록 도와드리겠습니다.</p>
			<br/>
			<a href="javascript:showDanal();" style="text-decoration: underline;">계속</a>
		</div>
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">Concert Ticket Checkout</h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<iframe id="checkout_frame" class="join-frame" src="" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
				</div>
			</div>
		</div>
	</div>

	<script>
	function danalCard(){
		if(checkValidation()){

    		var today = new Date();
    		var year  = today.getFullYear();
    		var month = today.getMonth() + 1;
    		var date  = today.getDate();
    		var time  = today.getTime();

    		if(parseInt(month) < 10) {
    			month = "0" + month;
    		}

    		if(parseInt(date) < 10) {
    			date = "0" + date;
    		}

    		var order_idxx = "DNPI" + year + "" + month + "" + date + "" + time;

    		var danalCardForm = $('<form></form>');
    		danalCardForm.attr("name","DanalCardForm");
    		danalCardForm.attr("method","post");
    		// danalCardForm.attr("action","https://humanity.kiosc.org/card/payment_dev.php");
    		// danalCardForm.attr("action","https://humanity.kiosc.org/card/payment.php");
    		danalCardForm.attr("action","card/payment.php");
    		danalCardForm.attr("target","danalpop");

    		danalCardForm.append($('<input/>', {type: 'hidden', name: 'orderid'   ,  value: order_idxx }));        // 주문번호
    		danalCardForm.append($('<input/>', {type: 'hidden', name: 'username'  , value: $('#mname').val() }));  // 주문자명
    		danalCardForm.append($('<input/>', {type: 'hidden', name: 'useremail' , value: $('#memail').val() })); // 주문자 이메일
    		danalCardForm.append($('<input/>', {type: 'hidden', name: 'userid'    , value: $('#memail').val() })); // 주문자 ID
    		danalCardForm.append($('<input/>', {type: 'hidden', name: 'useragent' , value: 'WP' }));
    		danalCardForm.append($('<input/>', {type: 'hidden', name: 'couponCode', value: $('#couponCode').val() }));

    		danalCardForm.appendTo('body');

    		var popupWidth = 800;
    		var popupHeight = 490;
    		var popupX = (window.screen.width / 2) - (popupWidth / 2);
    		var popupY= (window.screen.height / 2) - (popupHeight / 2);
    		danalpop = window.open('about:blank','danalpop','location=no,status=no,height='+popupHeight+',width='+popupWidth+',left='+popupX+',top='+popupY);

    		$("#danal_payment_background", parent.document).fadeTo(400, 0.7);
            $("#danal_payment_Info", parent.document).fadeIn(400);

    		danalCardForm.submit();
		}
	}

	function danalPhone(){
	}

	function showDanal(){
		if(typeof(danalpop)=='undefined' || danalpop.closed) {
			if(confirm('결제창을 찾을 수 없습니다. 결제를 다시 진행하시겠습니까?')){
				danalCard();
			}else{
				closeDanal();
			}
		}else{
			danalpop.focus();
		}
	}

	function closeDanal(){
		$("#danal_payment_background", parent.document).fadeOut(400);
	    $("#danal_payment_Info", parent.document).fadeOut(400);
	    if(!(typeof(danalpop)=='undefined' || danalpop.closed)){
	    	danalpop.close();
		}
	}

	function checkoutCompleted(){
		$("#danal_payment_background", parent.document).fadeOut(400);
	    $("#danal_payment_Info", parent.document).fadeOut(400);
		location.href = "../checkout_completed.php";
	}

	</script>
</body>
</html>
