<?
include_once("inc/common.php");

// $_pm_id = "0LK5721442912464P";
// $_pm_id = "0V952794JF825042C";
// $_pm_id = "1JR81852LT158644C";
// $_pm_id = "1UM531193L275530N";
// $_pm_id = "1XT40125PB128161F";
// $_pm_id = "2EU72781WM794651P";
// $_pm_id = "2LJ51851TL8844827";
// $_pm_id = "4UY259808V3755154";
// $_pm_id = "6K355028WG4829055";
// $_pm_id = "6RX309428Y1241252";
// $_pm_id = "7WS38450EW5368529";
// $_pm_id = "9NB7382183647920H";
// $_pm_id = "9UY86315MT6030708";
// $_pm_id = "14T72036S9749445J";
// $_pm_id = "36E39258J6782193C";
// $_pm_id = "49E48767B8039094J";
// $_pm_id = "61W41012U81821904";
// $_pm_id = "86F311753K225863C";

$_pm_id = "0LV20215LN6228211";
// $_pm_id = "40918845BN128720W";


createReceiptPdf($_pm_id, $conn);

// ----------------------------------
// Create Receipt PDF File
// ----------------------------------
function createReceiptPdf($_pm_id, $conn){

	$_pdf_name = "KIOSC_RECEIPT_".$_pm_id;
	$output_file = dirname(__FILE__)."/receipt/".$_pdf_name."_test.pdf";

	if(!file_exists($output_file)){

		$payment = getPaymentDataByPMID($_pm_id, $conn);

		$root_path  = $_SERVER['DOCUMENT_ROOT'];
		$root_path  = strpos($root_path, "/business_Jae") === false ? $root_path : str_replace("/business_Jae", "", $root_path);
		$tcpdf_path = $root_path."/libs/TCPDF-6.2.26/tcpdf.php";
		$tcpdf_include_path = $root_path."/libs/TCPDF-6.2.26/tcpdf_include.php";

		include_once($tcpdf_path);

		// create new PDF document
		$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		// set document information
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor('KIOSC');
		$pdf->SetTitle($_pdf_name);
		$pdf->SetSubject('');
		$pdf->SetKeywords('');

		$pdf->setPrintHeader(false);
		$pdf->setPrintFooter(false);

		// set default monospaced font
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

		// set margins
		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

		// set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

		// set image scale factor
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

		// set some language-dependent strings (optional)
		if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		    require_once(dirname(__FILE__).'/lang/eng.php');
		    $pdf->setLanguageArray($l);
		}

		// ---------------------------------------------------------

		// add a page
		$pdf->AddPage();

		$style_tf_line = array('width' => 6, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(67, 137, 178));

		// Page size x:210 - y:297

		// Line x-left-opsition, y-left-opsition, x-right-position, y-right-position, style
		$pdf->Line(0, 3, 210, 3, $style_tf_line);

		$pdf->SetFont('aefurat', '', 26);
		$pdf->SetTextColor(127, 127, 127);
		$pdf->Text(15, 25, 'RECEIPT');

		// Image example with resizing
		$pdf->Image('./images/logo_general.png', 145, 25, 50, 16, '', '', '', false, 100, '', false, false, 1, false, false, false);

		$info_width = array(145, 35);

		$pdf->Ln(30);

		$pdf->SetFillColor(243, 243, 243);
		$pdf->SetDrawColor(191, 191, 191);
		$pdf->SetLineWidth(0.2);
		$pdf->SetFont('nanumbarungothicyethangul', '', 10);

		$pdf->SetTextColor(0);
		$pdf->Cell($info_width[0], 6, "", 0, 0, 'L', false);
		$pdf->SetTextColor(31, 56, 100);
		$pdf->SetFont('helvetica');
		$pdf->Cell($info_width[1],  6, "PAYMENT DATE", "B", 0, 'C', false);


		$_payment_date = $payment[pm_u_data];
		$_payment_date = str_replace('T', ' ', $_payment_date);
		$_payment_date = str_replace('Z', ' ', $_payment_date);
		$pdf->Ln();
		$pdf->SetTextColor(0);
		$pdf->Cell($info_width[0], 6, "", 0, 0, 'L', false);
		$pdf->SetTextColor(0);
		$pdf->SetFont('nanumbarungothicyethangul');
		$pdf->Cell($info_width[1], 6, $_payment_date, 0, 0, 'C', false);


		$pdf->Ln();
		$pdf->SetTextColor(0);
		$pdf->Cell($info_width[0], 6, "", 0, 0, 'L', false);
		$pdf->SetTextColor(31, 56, 100);
		$pdf->SetFont('helvetica');
		$pdf->Cell($info_width[1], 6, "RECEIPT NO.", "B", 0, 'C', false);


		$pdf->Ln();
		$pdf->SetTextColor(0);
		$pdf->Cell($info_width[0], 6, "", 0, 0, 'L', false);
		$pdf->SetTextColor(0);
		$pdf->SetFont('nanumbarungothicyethangul');
		$pdf->Cell($info_width[1], 6, $_pm_id, 0, 0, 'C', false);

		// -------------------------------------------------------
		// From / BILL TO
		// -------------------------------------------------------
		$pdf->Ln(15);
		$pdf->SetTextColor(31, 56, 100);
		$pdf->SetFont('helvetica');
		$pdf->Cell(85, 7, "FROM", "B", 0, 'L', false);
		$pdf->Cell(10, 7, "", 0, 0, 'L', false);
		$pdf->Cell(85, 7, "BILL TO", "B", 0, 'L', false);

		$pdf->SetTextColor(0);


		$pdf->Ln();
		$pdf->SetFont('nanumbarungothicyethangul', '', 10);
		$pdf->Cell(85, 6, "KIOSC Training Center", 0, 0, 'L', false);
		$pdf->Cell(10, 6, "", 0, 0, 'L', false);
		$pdf->Cell(85, 6, $payment[m_name], 0, 0, 'L', false);

		$pdf->Ln();
		$pdf->Cell(85, 6, "20251 Centry Blvd.", 0, 0, 'L', false);
		$pdf->Cell(10, 6, "", 0, 0, 'L', false);
		if($payment[m_company] != ""){
			$pdf->Cell(85, 6, $payment[m_company], 0, 0, 'L', false);
		}else{
			$pdf->Cell(85, 6, $payment[m_email], 0, 0, 'L', false);
		}

		$pdf->Ln();
		$pdf->Cell(85, 6, "Suite 335", 0, 0, 'L', false);
		$pdf->Cell(10, 6, "", 0, 0, 'L', false);
		if($payment[m_company] != ""){
			$pdf->Cell(85, 6, $payment[m_email], 0, 0, 'L', false);
		}else{
			$pdf->Cell(85, 6, "", 0, 0, 'L', false);
		}

		$pdf->Ln();
		$pdf->Cell(85, 6, "Germantown, MD 20874", 0, 0, 'L', false);
		$pdf->Cell(10, 6, "", 0, 0, 'L', false);
		$pdf->Cell(85, 6, "", 0, 0, 'L', false);

		$pdf->Ln();
		$pdf->Cell(85, 6, "info@kiosc.org", 0, 0, 'L', false);
		$pdf->Cell(10, 6, "", 0, 0, 'L', false);
		$pdf->Cell(85, 6, "", 0, 0, 'L', false);

		// $pdf->Ln(15);
		// $pdf->Cell($info_width[0], 6, "", "B", 0, 'L', false);
		// $pdf->Cell($info_width[1], 6, "", "B", 0, 'C', false);

		// -------------------------------------------------------
		// Training Information Table
		// -------------------------------------------------------
		$pdf->Ln(20);
		$table_width = array(95, 15, 35, 35);
		$_header = array('DESCRIPTION', 'QTY', 'UNIT PRICE', 'TOTAL');

		$pdf->SetFillColor(67, 137, 178);
		$pdf->SetDrawColor(67, 137, 178);
		$pdf->SetTextColor(255);
		$pdf->SetLineWidth(0.1);
		$pdf->SetFont('helvetica', 'B');
		$pdf->Cell($table_width[0], 7, $_header[0], 1, 0, 'C', true);
		$pdf->Cell($table_width[1], 7, $_header[1], 1, 0, 'C', true);
		$pdf->Cell($table_width[2], 7, $_header[2], 1, 0, 'C', true);
		$pdf->Cell($table_width[3], 7, $_header[3], 1, 0, 'C', true);

		$pdf->Ln();
		// Color and font restoration
		$pdf->SetFillColor(243, 243, 243);
		$pdf->SetDrawColor(191, 191, 191);
		$pdf->SetTextColor(0);
		$pdf->SetLineWidth(0.1);
		$pdf->SetFont('nanumbarungothicyethangul');
		// Data
		$fill = false;
		foreach($payment[training] as $training) {
			$_row = ceil(strlen($training[tr_title]) / 55);
			$_cellHeight = 6 * $_row;
			// $pdf->Cell($table_width[0], 6, $training[tr_title], 1, 0, 'L', $fill);
			// MultiCell($w, $h, $txt, $border=0, $align='J', $fill=0, $ln=1, $x='', $y='', $reseth=true, $stretch=0, $ishtml=false, $autopadding=true, $maxh=0)
			// $pdf->MultiCell($table_width[0], $_cellHeight, $training[tr_title], 1, 'L', $fill, 0, '', '');
			$pdf->MultiCell($table_width[0], $_cellHeight, $training[tr_title], 1, '', $fill, 0, '', '', true, 0, false, true, $_cellHeight, 'M');
			$pdf->Cell($table_width[1], $_cellHeight, "1", 1, 0, 'C', $fill);
			$pdf->Cell($table_width[2], $_cellHeight, sprintf('%0.2f', number_format($training[tr_cost])), 1, 0, 'R', $fill);
			$pdf->Cell($table_width[3], $_cellHeight, sprintf('%0.2f', number_format($training[tr_cost])), 1, 0, 'R', $fill);
			$pdf->Ln();
			$fill=!$fill;
		}

		$pdf->SetLineWidth(0.1);

		$pdf->Ln(10);
		$pdf->SetTextColor(0);
		$pdf->Cell($table_width[0], 6, "", 0, 0, 'L', false);
		$pdf->SetTextColor(0);
		$pdf->Cell($table_width[1], 6, "", 0, 0, 'L', false);
		$pdf->SetTextColor(31, 56, 100);
		$pdf->SetFont('helvetica');
		$pdf->Cell($table_width[2], 6, "SUBTOTAL", 0, 0, 'R', false);
		$pdf->SetTextColor(0);
		$pdf->SetFont('nanumbarungothicyethangul');
		$pdf->Cell($table_width[3], 6, sprintf('%0.2f', $payment[pm_pre_amount]), "B", 0, 'R', false);

		if($payment[pm_discount] > 0){
			$pdf->Ln(8);
			$pdf->SetTextColor(0);
			$pdf->Cell($table_width[0], 6, "", 0, 0, 'L', false);
			$pdf->SetTextColor(0);
			$pdf->Cell($table_width[1], 6, "", 0, 0, 'L', false);
			$pdf->SetTextColor(31, 56, 100);
			$pdf->SetFont('helvetica');
			$pdf->Cell($table_width[2], 6, "DISCOUNT", 0, 0, 'R', false);
			$pdf->SetTextColor(0);
			$pdf->SetFont('nanumbarungothicyethangul');
			$pdf->Cell($table_width[3], 6, sprintf('%0.2f', $payment[pm_discount]), "B", 0, 'R', false);
		}

		$pdf->Ln(8);
		$pdf->SetDrawColor(0, 0, 0);
		$pdf->Cell($table_width[0], 6, "", 0, 0, 'R', false);
		$pdf->Cell($table_width[1], 6, "", 0, 0, 'R', false);
		$pdf->Cell($table_width[2], 6, "", "B", 0, 'R', false);
		$pdf->Cell($table_width[3], 6, "", "B", 0, 'R', false);

		$pdf->Ln(10);
		$pdf->Cell($table_width[0], 6, "", 0, 0, 'R', false);
		$pdf->Cell($table_width[1], 6, "", 0, 0, 'R', false);
		$pdf->SetFont('helvetica', 'B', 12);
		$pdf->Cell($table_width[2], 6, "Paid", 0, 0, 'R', false);
		$pdf->SetFont('nanumbarungothicyethangul', 'B', 12);
		$pdf->Cell($table_width[3], 6, "$".sprintf('%0.2f', $payment[pm_amount]), "B", 0, 'R', false);


		$pdf->Ln(20);
		$pdf->SetFont('helvetica', '', 10);
		$pdf->SetTextColor(0);
		$pdf->Cell(180, 6, "Thank you for your business.", 0, 0, 'R', false);


		// if(!file_exists($output_file)){
			// $pdf->Output($output_file, 'F');
		// }
	}
	$pdf->Output($output_file, 'I');

	// return $output_file;
}
// ----------------------------------
// Create Receipt PDF File
// ----------------------------------




// ----------------------------------
// Payment Data
// ----------------------------------
function getPaymentDataByPMID($_pm_id, $conn){

	$payment = array();
	$SQL = " SELECT m.m_id, m.m_name, m.m_email, m.m_company, p.* FROM payment p JOIN member m ON m.m_idx = p.m_idx WHERE p.pm_id = '$_pm_id' LIMIT 1 ";
	$Result = mysqli_query($conn, $SQL);

	while ($ResultsRow = mysqli_fetch_array($Result, MYSQLI_ASSOC)) {
		$payment = $ResultsRow;
	}

	$training_list = array();
	$SQL = " SELECT * ";
	$SQL.= " FROM payment_training ";
	$SQL.= " WHERE pm_idx = '".$payment[pm_idx]."' ";
	$SQL.= " ORDER BY tr_idx ASC ";
	$Result = mysqli_query($conn, $SQL);

	while ($ResultsRow = mysqli_fetch_array($Result, MYSQLI_ASSOC)) {
		array_push($training_list, $ResultsRow);
	}

	$payment[training] = $training_list;

	return $payment;
}
// ----------------------------------
// Payment Data
// ----------------------------------

?>
